Declare Sub Gfx_Buffer_Stretch ( ByRef Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr )

Declare Sub Gfx_Buffer_Stretch_Aspect ( ByRef Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr, Aspect_Correction As String = "height" )

Declare Sub Gfx_Buffer_Inlay ( ByRef Source As FB.Image Ptr, Dest As FB.Image Ptr )

Declare Sub Gfx_Buffer_Repeat ( ByRef Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr )

Declare Sub Gfx_Buffer_Wallpaper ( Filename As String = "", ByRef Dest As FB.Image Ptr )

Declare Sub Gfx_vbox ( dest_mask as fb.image ptr, x1 as integer = 1, y1 as integer = 1, x2 as integer = 1, y2 as integer = 1, odd as integer = - 1, even as integer = 0 )

Declare Sub Gfx_Buffer_Fill ( Dest_Mask As FB.Image Ptr, x1 As Long = 1, y1 As Long = 1, x2 As Long = 1, y2 As Long = 1, Odd As Long = - 1, Even As Long = 0, Font As String = "Fill" )

Declare Function Gfx_Make_Fill ( even As Long = 15, odd As Long = - 1 ) As FB.Image Ptr

Declare Function Gfx_Validate_Display ( ) As Long

Sub Gfx_Buffer_Stretch ( ByRef Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr )

	Dim As Long Source_X, Source_Y, Dest_X, Dest_Y

	Dim As FB.Image Ptr Intermediary

	Intermediary = ImageCreate ( Source - > Width, Dest - > Height, RGBA ( 0, 0, 0, 0 ), 32 )

	For Dest_Y = 0 To Dest - > Height - 1 Step 1

		Source_Y = ( Dest_Y * Source - > Height ) \ Dest - > Height

		Put Intermediary, ( 0, Dest_Y ), Source, ( 0, Source_Y ) - Step ( Source - > Width - 1, 0 ), PSet

	Next Dest_Y

	For Dest_X = 0 To Dest - > Width - 1 Step 1

		Source_X = ( Dest_X * Source - > Width ) \ Dest - > Width

		Put Dest, ( Dest_X, 0 ), Intermediary, ( Source_X, 0 ) - Step ( 0, Intermediary - > Height - 1 ), PSet

	Next Dest_X

	ImageDestroy ( Intermediary )

End Sub

Sub Gfx_Buffer_Stretch_Aspect ( ByRef Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr, Aspect_Correction As String = "height" )

	Dim As Integer Dest_X = 0, Dest_Y = 0, Source_X = 0, Source_Y = 0

	Dim As FB.Image Ptr Intermediary

	Select Case LCase ( Aspect_Correction )

	Case "height", "h"

		If Dest - > Width / Dest - > Height > Source - > Width / Source - > Height Then

			Intermediary = ImageCreate ( Dest - > Height * Source - > Width / Source - > Height, Dest - > Height, RGBA ( 0, 0, 0, 0 ) )

			ImageDestroy ( Dest )

			Dest = ImageCreate ( Intermediary - > Width, Intermediary - > Height, RGBA ( 0, 0, 0, 0 ) )

			ImageDestroy ( Intermediary )

		End If

	Case "width", "w"

		If Dest - > Width / Dest - > Height < Source - > Width / Source - > Height Then

			Intermediary = ImageCreate ( Dest - > Height * Source - > Width / Source - > Height, Dest - > Width, RGBA ( 0, 0, 0, 0 ) )

			ImageDestroy ( Dest )

			Dest = ImageCreate ( Intermediary - > Width, Intermediary - > Height, RGBA ( 0, 0, 0, 0 ) )

			ImageDestroy ( Intermediary )

		End If

	End Select

	Gfx_Buffer_Stretch ( Source, Dest )

End Sub

Sub Gfx_Buffer_Inlay ( ByRef Source As FB.Image Ptr, Dest As FB.Image Ptr )

	Put Dest, ( ( Dest - > Width - Source - > Width ) \ 2, ( Dest - > Height - Source - > Height ) \ 2 ), Source, Alpha
	
End Sub

Sub Gfx_Buffer_Repeat ( ByRef Source As FB.Image Ptr, ByRef Dest As FB.Image Ptr )

	Dim As Long Dest_X = 0, Dest_Y = 0

	For Dest_Y = 0 To Dest - > Height - 1 Step Source - > Height
		
		For Dest_X = 0 To Dest - > Width - 1 Step Source - > Width
			
			Put Dest, ( Dest_X, Dest_Y ), Source, Alpha
			
		Next Dest_X
		
	Next Dest_Y

End Sub

Sub Gfx_Buffer_Wallpaper ( Filename As String = "", ByRef Dest As FB.Image Ptr )

	Dim As FB.Image Ptr Source = LoadRGBAFile ( ".\" & ProjectSpace & "\Assets\Sprites\" & Filename & ".png" )

	Gfx_Buffer_Repeat ( Source, Dest )

	ImageDestroy ( Source )

End Sub

Function Gfx_Make_Fill ( even As Long = 15, odd As Long = - 1 ) As FB.Image Ptr

	Dim As FB.Image Ptr Fill = ImageCreate ( 8, 8, RGBA ( 0, 0, 0, 0 ), 32 )

	Dim As Long X = 2

	If even = - 1 Then

		even = RGBA ( 0, 0, 0, 96 )

	Else

		even = VGA_Lookup ( even ) Or RGBA ( 0, 0, 0, 96 )

	End If

	If odd = - 1 Then

		odd = RGBA ( 0, 0, 0, 128 )

	Else

		odd = VGA_Lookup ( odd ) Or RGBA ( 0, 0, 0, 128 )

	End If

	Line Fill, ( 0, 0 ) - ( 1, 1 ), odd

	Line Fill, ( 0, 1 ) - ( 1, 0 ), even

	Do While X < = Fill - > Width

		Put Fill, ( X, 0 ), Fill, ( 0, 0 ) - ( X, X ), Alpha

		Put Fill, ( 0, X ), Fill, ( 0, 0 ) - ( X, X ), Alpha

		Put Fill, ( X, X ), Fill, ( 0, 0 ) - ( X, X ), Alpha

		If X shl 1 > Fill - > Width Then Exit Do

		X = X shl 1

	Loop

	Return Fill

End Function

'100 percent

sub Gfx_vbox ( dest_mask as fb.image ptr, x1 as integer = 1, y1 as integer = 1, x2 as integer = 1, y2 as integer = 1, odd as integer = - 1, even as integer = 0 )

	Dim As FB.Image Ptr Fill = ImageCreate ( 128, 128, RGBA ( 0, 0, 0, 0 ), 32 )

	Dim As Long X = 0, Y = 0

	Fill = Gfx_Make_Fill ( even, odd )

	for Y = ( y1 - 1 ) shl 3 to ( y2 - 1 ) shl 3 + 7 step Fill - > Height

	for X = ( x1 - 1 ) shl 3 to ( x2 - 1 ) shl 3 + 7 step Fill - > Width

		Put Dest_Mask, ( X, Y ), Fill, Alpha

	next X

	next Y

end sub

Sub Gfx_Buffer_Fill ( Dest_Mask As FB.Image Ptr, x1 As Long = 1, y1 As Long = 1, x2 As Long = 1, y2 As Long = 1, Odd As Long = - 1, Even As Long = 0, Font As String = "Fill" )

	Dim As FB.Image Ptr Fill
	Fill = LoadRGBAFile ( ".\" & ProjectSpace & "\Assets\Fonts\" & Font & ".png" )

	Dim As Long X = 0, Y = 0

	'Fill = Gfx_Make_Fill ( even, odd )

	For Y = ( y1 - 1 ) Shl 3 to ( y2 - 1 ) Shl 3 + 7 Step 8

	For X = ( x1 - 1 ) Shl 3 to ( x2 - 1 ) Shl 3 + 7 Step 8

		Put Dest_Mask, ( X, Y ), Fill, ( 0, 0 ) - ( 7, 7 ), Alpha

	Next X

	Next Y

End Sub

Function Gfx_Validate_Display ( ) As Long

	Dim As FB.Image Ptr DispTest

	DispTest = ImageCreate ( 1, 1 )

	If DispTest = 0 Then

		ScreenRes 640, 480, 32, 16

		ScreenSet 1, 0

		color VGA_Lookup ( 15 ) Or ( &HFF Shl 24 )

		print "Your Display has been Validated."

		Flip

		sleep

		Sleep 1, 1

	Else

		ImageDestroy ( DispTest )

	End If

	Return 0

End Function

